#!/bin/sh
# SetLic.sh -- Sets License for CheckPoint Firewall-1
# dd-MMM-CCYY JP Vossen <jp@jpsdomain.org> http://www.jpsdomain.org/

# Set the Firewall-1 Directory, if it's not already set.  But on Nokia/IPSO
# it really *should* already be set!
  if [ -z "${FWDIR}" ]; then
    echo "FWDIR not set -- fatal error!"
    exit 1
#    FWDIR=
  fi

# v4.0 Examples
# Cert Key: 9999 8888 7777
# Type: CPFW-FM-U-V40 (Firewall Module)
# ${FWDIR}\bin\fw putlic 10.10.10.10 7ddd2945-edb35791-c2d712ab pfmx des skip controlx des skip
# ${FWDIR}\bin\fw putlic -overwrite 10.10.10.10 7ddd2945-edb35791-c2d712ab pfmx des skip controlx des skip

# v4.1 Examples
# REAL v4.1 Lic.
# Cert Key: 9999 8888 7777
# Type: CPFW-FM-U-V41 (Firewall Module)
# ${FWDIR}\bin\fw putlic 10.10.10.10 never a6Nf3efJg-3XxEYq382-6gGGFNlPD-Bz3yQ55tf cpfw-fm-u-v41 CK-9C4873826C5A
# ${FWDIR}\bin\fw -overwrite putlic 10.10.10.10 never a6Nf3efJg-3XxEYq382-6gGGFNlPD-Bz3yQ55tf cpfw-fm-u-v41 CK-9C4873826C5A

