#!/bin/sh
# LogSwap.sh -- Schedule or Swap Firewall-1 Logs
# v1.0 29-Apr-1999 JP Vossen <jp@jpsdomain.org>
# v1.1 29-Apr-1999 JPV, Added GZip and del *.alog, path variables
# v1.2 11-May-1999 JPV, Minor bugfixes (not fully tested yet!) and docs
# v1.3 05-Aug-1999 JPV, Minor bugfixes (not fully tested yet!) and "Move"
# v1.4 16-Oct-2000 JPV, updated for CP FW-1 v4.1 (tested well with v4.0, not
#	as well with 4.1 yet.
# v1.5 13-Nov-2000 JPV, Bugfix for logging directory.
# v2.0 27-Nov-2000 JPV, Added "Obsolete" for log file purge, added a little
#	extra logging
# v2.1 28-Nov-2000 JPV, Bugfix for .BAT v .CMD inconsistencies and added
#	text re: LogSwap.txt purge (or lack thereof)

# v1.0 29-Aug-2001 JPV, UNIX Port (tested on Nokia IPSO v3.3.1-FCS4) and
#	add more ELA log handling
# v1.1 30-Aug-2001 JPV, Added a lot more misc "other" log handling, add chmod
# v1.2 14-Sep-2001 JPV, Minor consistency and typo edits, slight re-org
#			for an ELA_proxy log copy BUGFIX.
# v1.3 27-Sep-2001 JPV, Tested on Nokia 3.4.1-FCS5 with CP FW v4.1 SP5

MyVer=1.3


# Part of CPFW1TK -- CheckPoint Firewall-1 Tool Kit
#	by JP Vossen <jp@jpsdomain.org> http://www.jpsdomain.org/
#	http://www.jpsdomain.org/security/tools.html#firewalls

# Note: LogSwap is not needed for CheckPoint Firewall-1/VPN-1 Next
# Generation (AKA v5.x) -- use the built-in logging facility.

# Note: ironically, there is no purge for the log file that THIS program
# creates. However, each time LogSwap runs, it should genereate less than 800
# bytes of log file text. If it runs once a week, 800 * 52 = 41,600 bytes.
# Even once a day, 800 * 365 = 292,000. At this rate, you will replace the
# firewall server long before LogSwap.txt gets large enough to matter.

# See http://www.phoneboy.com/faq/0288.html and
# http://msgs.SecurePoint.com/cgi-bin/get/fw1-0011/7.html for more
# information about the misc. "other" logs that are generated.

# ##########################################################################
# ##### Varables you may need to modify

# Set the Firewall-1 Directory, if it's not already set.  But on Nokia/IPSO
# it really *should* already be set!
  if [ -z "${FWDIR}" ]; then
    echo "FWDIR not set -- fatal error!"
    exit 1
#    FWDIR=
  fi

# Determine if we should purge old log files, set to 0 if not
# PurgeDays is the number of days old the file "change" time should be to
# purge the file.
# Our default is to purge anything older than 8 months
  PurgeOldLogs=1
  PurgeDays=240     # 8 months * 30 days = 240

# Determine if we should use GZip or not, set to 0 if not
  UseGZip=1

# The Firewall-1 Log Directory (Change if you are logging elsewhere)
  FWLogDir=${FWDIR}/log

# The directory where archived (gzipped) logs are stored (may be ${FWLogDir})
  LogSaveDir=/var/admin/save-logs

# The Log file for this Batch File
  LogFile=LogSwap.txt

# The date/time stamp in the same (stupid) format as CheckPoint:
# e.g. 29Aug2001-14:54:31.  20010829-145431 makes much more sense, but in
# the interest of consistency and grouping log files together by time...
  DATE=`date +%d%b%Y-%H:%M:%S`

# ##########################################################################

# Use Cron (crontab -e) to schedule the job.  E.G.

  # LogSwap every day at 11:55pm (so the date is the "correct" date)
  # Note that breaking the log file every day makes it harder to track
  # suspect activity.  But the logs can quickly get unmanagably large,
  # depending on log volume, if you do not swap them "often".
  # 55 23 * * * /var/admin/LogSwap.sh

  # LogSwap every Sunday at 11:55pm   (This is what I usually use)
  # 55 23 * * 0 /var/admin/LogSwap.sh

  # LogSwap the 1st and 15th 11:55pm
  # 55 23 1,15 * * /var/admin/LogSwap.sh

# ##########################################################################

# Make sure the directories and tools we need exist
if [ ! -d ${LogSaveDir} ]; then
  mkdir -p ${LogSaveDir}
fi

if [ ! -x "${FWDIR}/bin/fw" ]; then
  echo ""
  echo "${FWDIR}/bin/fw missing or fw not executable!!!"
  echo ""
  exit 2
fi

# IPSO v3.3.1 doesn't have an external which command; it's built into csh
# But I'm not using csh to process this script, so which doesn't work! :-(
#which date find gzip mv rm > /dev/nul  2>&1
#if [ ! "$?" = 0 ]; then
#  echo ""
#  echo "date, find, gzip, mv or rm not in path, exiting!!!"
#  echo ""
#  exit 3
#fi

# ##########################################################################

echo ""
echo "Read the disclaimer in DISCLAIMER.txt!"
echo ""

# Log that we ran
echo "" >> ${LogSaveDir}/${LogFile}
echo "`date` Starting $0 ${MyVer} for Firewall-1" >> ${LogSaveDir}/${LogFile}

# Swap the logs.  See CP FW-1v4 pgs AA234, or run fw /? for help.
echo "`date` ${FWDIR}/bin/fw logswitch" >> ${LogSaveDir}/${LogFile}
${FWDIR}/bin/fw logswitch

# Logswitch creates the following files (using the current date-time) e.g.:
# 29Apr1998-120948.alog
# 29Apr1998-120948.alogptr
# 29Apr1998-120948.log
# 29Apr1998-120948.logptr

# The *.alogptr and *.logptr files are useless pointer files, so delete them
# (per FW-1 Mailing list). Do NOT delete *.logptr as that will hose fw.logptr,
# killing current logging!!!
echo "`date` Removing unnecessary files" >> ${LogSaveDir}/${LogFile}
rm -f ${FWLogDir}/?????????-*.alogptr
rm -f ${FWLogDir}/?????????-*.logptr

# Kill the *.alog (Accounting Log) files. If you are using "Track" by
# "Accouting" in any rule -- DO NOT DO THIS! See CP FW-1v4 pgs WI179, WI228.
# rm -f ${FWLogDir}/?????????-*.alog

# New with v4.1, the ELA_Proxy logs. E.G.
#     ela_proxy.log
#     ela_08172001_163247.alog
#     ela_08172001_163247.alogptr
#     ela_08172001_163247.log
#     ela_08172001_163247.logptr
# So Remove pointer files
rm -f ${FWLogDir}/ela_*.logptr
rm -f ${FWLogDir}/ela_*.alogptr
rm -f ${FWLogDir}/ela_*.vlogptr

# Move misc. "other" logs (not all of these will exist in all configs!)
# None of these are handled by fw logswitch?!?
# (http://msgs.SecurePoint.com/cgi-bin/get/fw1-0011/7.html)
movelogs ()
{
    if [ -s ${FWLogDir}/$1 ]; then
        mv ${FWLogDir}/$1 ${LogSaveDir}/${DATE}.$1
    fi
}

# List of misc. "other" logs to move (this should handle all versions up to
# v4.1! .elg are mostly v4.1, .log are mostly v4.0 and below.
movelogs aclientd.elg
movelogs aclientd.log
movelogs aftpd.elg
movelogs aftpd.log
movelogs ahttpd.elg
movelogs ahttpd.log
movelogs ahttpdauth1.elg
movelogs ahttpdauth2.elg
movelogs arlogind.elg
movelogs arlogind.log
movelogs asmtpd.elg
movelogs asmtpd.log
movelogs atelnetd.elg
movelogs atelnetd.log
movelogs cpmgmt.aud
movelogs ela_proxy.log
movelogs fwd.elg
movelogs fwd.log
movelogs fwui.log
movelogs mdq.elg
movelogs mdq.log
movelogs netsod.elg
movelogs polsrvd.elg
movelogs sam.log


# Move the old log file(s) to the archive location
# These may not always exist, but since I don't know the names I can't test
# for them. /dev seems to be read-only (!) on Nokia, so since I can't send
# errors to /dev/nul, I redirect to STDERR to a file I later delete.
echo "`date` Moving old logs to ${LogSaveDir}" >> ${LogSaveDir}/${LogFile}
mv ${FWLogDir}/?????????-*.log  ${LogSaveDir} 2> ${LogSaveDir}/devnul
mv ${FWLogDir}/?????????-*.alog ${LogSaveDir} 2> ${LogSaveDir}/devnul
mv ${FWLogDir}/ela_*.log        ${LogSaveDir} 2> ${LogSaveDir}/devnul
mv ${FWLogDir}/ela_*.alog       ${LogSaveDir} 2> ${LogSaveDir}/devnul
mv ${FWLogDir}/ela_*.vlog       ${LogSaveDir} 2> ${LogSaveDir}/devnul


# Stop & Start the firewall to re-set the logs (that have been yanked out
# from under it).  Not needed only for fw switch, but needed for all the
# misc "other" logs (I *think* -- can anyone prove me wrong???).
# Different in the Windows version.
echo "`date` Bouncing the firewall" >> ${LogSaveDir}/${LogFile}
${FWDIR}/bin/fwstop
${FWDIR}/bin/fwstart


# GZip the log file (i.e. "gzip -9 log.log"  = log.log    --> log.log.gz)
# Use gunzip or "gzip -d" (ie "gunzip log.log.gz" = log.log.gz --> log.log)
# See "gzip -h" for more info.  Use gunzip -d *.gz to gunzip lots of files...
if [ "${UseGZip}" -ne 0 ]; then
  echo "`date` Gzipping ${LogSaveDir}/*.log, *.?log, *.elg, *.aud" >> ${LogSaveDir}/${LogFile}
  gzip -9 ${LogSaveDir}/*.log  2> ${LogSaveDir}/devnul
  gzip -9 ${LogSaveDir}/*.alog 2> ${LogSaveDir}/devnul
  gzip -9 ${LogSaveDir}/*.vlog 2> ${LogSaveDir}/devnul
  gzip -9 ${LogSaveDir}/*.elg  2> ${LogSaveDir}/devnul
  gzip -9 ${LogSaveDir}/*.aud  2> ${LogSaveDir}/devnul
fi

# Remove the pseudo /dev/nul file
if [ -f ${LogSaveDir}/devnul ]; then
    rm -f ${LogSaveDir}/devnul
fi

# Set better protection on the log archive
echo "`date` chmod -R 600 ${LogSaveDir}/*" >> ${LogSaveDir}/${LogFile}
chmod -R 600 ${LogSaveDir}/*

# Note that the log files archived above are in a binary form that can be read
# by opening the file in the GUI LogViewer. If you want the logs in ASCII
# Form, for analysis in Perl, Excel, Access, etc., use the fw logexport
# command.
# (e.g. fw logexport -d , -n -i 29Apr1998-120948.log -o 29Apr1998-120948.txt)
# CP FW-1v4 pgs AA241, or run fw /? for help.

# Purge old log files.
if [ "${PurgeOldLogs}" -ne 0 ]; then
  echo "`date` Starting log purge: ${LogSaveDir}/*.gz not modified in ${PurgeDays} days" >> ${LogSaveDir}/${LogFile}
  find ${LogSaveDir} -name '*.gz' -mtime +${PurgeDays} -print >> ${LogSaveDir}/${LogFile}
  find ${LogSaveDir} -name '*.gz' -mtime +${PurgeDays} -exec rm -f {} \;
  echo "`date` Log purge complete" >> ${LogSaveDir}/${LogFile}
fi

# Log that we finished cleanly...
echo "`date` -----Ending $0 " >> ${LogSaveDir}/${LogFile}

