#!/bin/sh
# CPFWBack.cmd -- Backup CheckPoint Firewall-1 Configurations (runs on NT only)
# v1.0 03-Dec-2000 JP Vossen (Windows version)
# 26-Mar-2001 Installed on OLD FW1
# v1.1 28-Mar-2001 JPV Added "fw ver" to misc info collection
# v1.0 28-Aug-2001 JPV UNIX Port (tested on Nokia IPSO v3.3.1-FCS4)
# v1.1 30-Aug-2001 JPV Minor typo corrections, add -o to tar, add chmod
# v1.2 27-Sep-2001 JPV, Minor consistency and typo edits, add fw printlic
#		and tested on Nokia 3.4.1-FCS5 with CP FW v4.1 SP5

MyVer=1.2

# Part of CPFW1TK -- CheckPoint Firewall-1 Tool Kit
#	by JP Vossen <jp@jpsdomain.org> http://www.jpsdomain.org/
#	http://www.jpsdomain.org/security/tools.html#firewalls


# As far as I know, this script will work for all versions of Firewall-1/VPN-1
# up to and including Next Generation (AKA v5.x).


# Known Issues:
# This script will not deal well with tools, config and Firewall directories
# located on different drives.  The zip/unzip tools do not save drive letters in paths
# so restoring different files to different directories will not work.  Everything
# will be restored to whatever the CURRENT driver letter is.  The scripts will save
# everything OK, you will just have to manually move some directories around if/when
# you need to do a restore.


# ##########################################################################
# ##### Varables you may need to modify

# The directory in which to save the "backup" configs
  SaveDir=/var/admin/save-configs

# Set the Firewall-1 Directory, if it's not already set.  But on Nokia/IPSO
# it really *should* already be set!
  if [ -z "${FWDIR}" ]; then
    echo "FWDIR not set -- fatal error!"
    exit 1
#    FWDIR=
  fi

# ##########################################################################
# ##### Preprocessing

# The current date/time as CCYYMMDD-HHmm
  MyDateTime=`date +%Y%m%d-%H%M`

# This machine's host name
  MyHostName=`hostname -s`

# The TarFile name, you should probably just use the machine's hostname
# DON'T end in .tar, that gets added later.
  TarName=${MyHostName}

# Make sure the directories and tools we need exist
if [ ! -d ${SaveDir} ]; then
  mkdir -p ${SaveDir}
fi

if [ ! -x "${FWDIR}/bin/fw" ]; then
  echo ""
  echo "${FWDIR}/bin/fw missing or fw not executable!!!"
  echo ""
  exit 2
fi

# IPSO v3.3.1 doesn't have an external which command; it's built into csh
# But I'm not using csh to process this script, so which doesn't work! :-(
#which arp cat date grep gzip hostname ifconfig ln mv netstat rm \
#       tar > /dev/nul  2>&1
#if [ ! "$?" = 0 ]; then
#  echo ""
#  echo "arp, cat, date, grep, gzip, hostname, ifconfig, ln, mv, netstat, rm or tar
#  not in path, exiting!!!"
#  echo ""
#  exit 3
#fi

# Collect some "misc" info
echo ""
echo "Read the disclaimer in DISCLAIMER.txt!"
echo ""
echo "Collecting hosts, routes, proxy arps and ifconfig -a"
echo "in ${SaveDir}/${MyHostName}.txt..."
echo ""

echo "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++" >  ${SaveDir}/${MyHostName}.txt
echo "Generated by $0  v${MyVer} on `date`"                                        >> ${SaveDir}/${MyHostName}.txt
echo "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++" >> ${SaveDir}/${MyHostName}.txt
echo "+++++ FW Ver"                                                                >> ${SaveDir}/${MyHostName}.txt
${FWDIR}/bin/fw ver                                                                >> ${SaveDir}/${MyHostName}.txt 2>&1
${FWDIR}/bin/fw ver -k                                                             >> ${SaveDir}/${MyHostName}.txt 2>&1
echo ""                                                                            >> ${SaveDir}/${MyHostName}.txt
${FWDIR}/bin/fw printlic                                                           >> ${SaveDir}/${MyHostName}.txt 2>&1
echo "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++" >> ${SaveDir}/${MyHostName}.txt
echo "+++++ /etc/hosts"                                                            >> ${SaveDir}/${MyHostName}.txt
echo ""                                                                            >> ${SaveDir}/${MyHostName}.txt
cat /etc/hosts                                                                     >> ${SaveDir}/${MyHostName}.txt
echo ""                                                                            >> ${SaveDir}/${MyHostName}.txt
echo "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++" >> ${SaveDir}/${MyHostName}.txt
echo "+++++ Routes"                                                                >> ${SaveDir}/${MyHostName}.txt
echo ""                                                                            >> ${SaveDir}/${MyHostName}.txt
netstat -rn                                                                        >> ${SaveDir}/${MyHostName}.txt
echo ""                                                                            >> ${SaveDir}/${MyHostName}.txt
echo "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++" >> ${SaveDir}/${MyHostName}.txt
echo "+++++ Proxy Arps"                                                            >> ${SaveDir}/${MyHostName}.txt
echo ""                                                                            >> ${SaveDir}/${MyHostName}.txt
arp -an                                                                            >> ${SaveDir}/${MyHostName}.txt
echo ""                                                                            >> ${SaveDir}/${MyHostName}.txt
echo "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++" >> ${SaveDir}/${MyHostName}.txt
echo "+++++ Listening on Ports:"                                                   >> ${SaveDir}/${MyHostName}.txt
echo ""                                                                            >> ${SaveDir}/${MyHostName}.txt
netstat -an | grep -i listen                                                       >> ${SaveDir}/${MyHostName}.txt
echo ""                                                                            >> ${SaveDir}/${MyHostName}.txt
echo "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++" >> ${SaveDir}/${MyHostName}.txt
echo "+++++ hostname, ifconfig -a"                                                 >> ${SaveDir}/${MyHostName}.txt
echo ""                                                                            >> ${SaveDir}/${MyHostName}.txt
hostname                                                                           >> ${SaveDir}/${MyHostName}.txt
echo ""                                                                            >> ${SaveDir}/${MyHostName}.txt
ifconfig -a                                                                        >> ${SaveDir}/${MyHostName}.txt
echo ""                                                                            >> ${SaveDir}/${MyHostName}.txt


# ##########################################################################
# ##### Now, tar/gzip up the files
# ##### See http://www.phoneboy.com/fw1/faq/0196.html and the CheckPoint docs
# ##### for more information.

# Note: the Phoneboy docs specify files, and make a distinction between a
# firewall module and a management station.  I do not do either of those
# things.  The few extra files we pick up should not be a big deal, and we
# will just not get management files when running on a module, and vice versa.
# That's one reason to use the Hostname in the Tar file, you know which machine
# to restore to!!!  See end of this script for more on this.

echo ""
echo ""
echo "Collecting/Compressing configuration to ${SaveDir}/${TarName}..."
echo ""

# Save the "misc" info from above, the conf & DB directories, and this script
# Need the -o tar switch (write a V7 format archive, rather than ANSI
# format) so that WinZip can read the file (just in case).
  tar -covf ${SaveDir}/${TarName} ${SaveDir}/${MyHostName}.txt ${FWDIR}/conf/* \
           ${FWDIR}/database/* $0

# ##########################################################################
# ##### Post Processing

echo ""
echo ""
echo "Archiving ${SaveDir}/${TarName} to ${SaveDir}/${MyDateTime}.${TarName}.tar.gz..."
echo ""

gzip -9 ${SaveDir}/${TarName}
mv ${SaveDir}/${TarName}.gz ${SaveDir}/${MyDateTime}.${TarName}.tar.gz

# If the "latest" file exists, delete it
  if [ -f "${SaveDir}/Latest-${TarName}.tar.gz" ]; then
    rm -f ${SaveDir}/Latest-${TarName}.tar.gz
  fi

# Create "Latest" symlink
ln -s ${SaveDir}/${MyDateTime}.${TarName}.tar.gz ${SaveDir}/Latest-${TarName}.tar.gz

# Set better protection on the config archive
chmod -R 600 ${SaveDir}/*


# ##########################################################################

  echo ""
  echo "Don't forget to backup your log files too!"
  echo ""
  echo "You can get a free Windows FTP server from this URL, then FTP files *from*"
  echo "the firewall to a server or workstation on the LAN."
  echo "	http://support.3com.com/software/utilities_for_windows_32_bit.htm"
  echo ""
  echo "You'll have to add a rule to the firewall to allow it to FTP to the LAN."
  echo "Don't EVER run the FTP server on the firewall itself!  Run the FTP server"
  echo "inside, then FTP *from* the firewall, and shut the FTP server off when"
  echo "you're done."
  echo ""
  echo "If you need to restore the backup, 'fwstop', do the restore and 'fwstart'."
  echo ""
  echo ""

