#include <stdio.h>

int julian_day(int, int, int);
void inverse_julian_day(int, int*,int*,int*);

main()
{
    int offset;		/* offset into the julian day */
    int y,m,d;		/* invers jul day */
    int i,j,k;		/* loop for year/month/day */
    int erg;
    int old;

    offset=julian_day(1988,1,1);

/*    printf("off: %d\n",offset); */

    for(i=1988; i<=1998; i++) {
    for(j=1; j<=12; j++) {
	erg=julian_day(i,j,1);
        inverse_julian_day(erg,&y,&m,&d);
	printf("Y: %4d ergabs: %6d ergrel: %5d Y: %4d M: %2d D: %2d\n",
               i,erg,erg-offset,y,m,d);
    }
    }

}

/*
    this works, indeed !
    from a given date, gives a continous day-number relative to some
    date in the past, correcting leap-years etc.
*/
int julian_day(int year, int month, int day)
{

    int tmp;

    tmp = day - 32075 + 1461 * (year + 4800 - (14 - month)/12)/4 +
       367 * (month - 2 + (14 - month)/12*12)/12 -
       3 * ((year + 4900 - (14 - month)/12)/100)/4;
 
    return(tmp);

}

void inverse_julian_day(int jul_day, int *year, int *month, int *day)
{
    int temp1,temp2;

    temp1 = jul_day + 68569;
    temp2 = 4*temp1/146097;
    temp1 = temp1 - (146097 * temp2 + 3) / 4;
    *year = 4000 * (temp1 + 1) / 1461001;
    temp1 = temp1 - 1461 * (*year)/4 + 31;
    *month= 80 * temp1 / 2447;
    *day  = temp1 - 247 * (*month) / 80;
    temp1 = (*month) / 11;
    *month= (*month) + 2 - 12 * temp1;
    *year = 100 * (temp2 - 49) + (*year) + temp1;

}

