=head1 NAME

DBD::ODBC::Changes - Log of significant changes to the DBD::ODBC

=cut

=head1 Todo

 I'll be building this list shortly.
 ++ done ++ Make ODBC version 3.0 default!
 ++ done ++ Document more of the DBD::ODBC private attributes/functions.
 Add array parameter binding (per new DBI Spec)
 Add row caching/multiple row fetches to speed selects
 Better/more tests on multiple statement handles which ensure the correct number of rows
 Better/more tests on all queries which ensure the correct number of rows and data
 Better tests on SQLExecDirect/do
 ++ done ++ Change default behaviour to use SQLDescribeParam instead of SQL_VARCHAR.

 Keep checking Oracle's ODBC drivers for Windows to fix the Date binding problem

=head1 CHANGES

=head2 Changes in DBD::ODBC 1.13 November 8, 2004

Fix inconsistency/bug with odbc_exec_direct vs. odbc_execdirect settings.  Now made consistent with
odbc_exec_direct.  For now, will still look for odbc_execdirect in prepare, but not as DBH attribute
as a backup (which is what it was doing), but that support will be dropped at some time in the future. 
Please use odbc_exec_direct from now on...

Fix handling of print statements for SQL Server thanks to Martin Evans!  Thanks for all your work on this! 
Due to bug in SQL Server, you must use odbc_exec_direct.  See t/20SqlServer.t for example.  You will need
to call $sth->{odbc_more_results} to clear out any trailing messages.

Change tests to use Test::More.  Whew, that's much nicer!

Fix Oracle integral/numeric output params so that warning not printed about value not being numeric (even though it is!)

=head2 Changes in DBD::ODBC 1.12 October 26, 2004

Fix bug with odbc_execdirect attributed thanks to Martin Evans
Fix bug(s) with odbc_query_timeout and tested with SQL*Server.  
Oracle tests failed with setting timeout.  Probably not handled by Oracle's ODBC driver

=head2 Changes in DBD::ODBC 1.11 October 11, 2004

Added odbc_timeout, but untested

=head2 Changes in DBD::ODBC 1.10 September 8, 2004

Fixed bug in Makefile.PL.
Added pod.t test, taken from DBI.
Fixed various small POD issues, discovered during the pod test.
Fixed bug in bind_param_inout

=head2 Changes in DBD::ODBC 1.09 March 10, 2004

Duh.  I forgot to add new dbivport.h to MANIFEST and SVN before submitting.  Fixed.

=head2 Changes in DBD::ODBC 1.08 March 6, 2004

Added check in Makefile.PL to detect if the environment variable LANG is 
Set.  If so, prints a warning about potential makefile generation issues.
Change to use dbivport.h per new DBI spec.
Add ability to set the cursor type during the connect.  This may allow some servers
which do not support multiple concurrent statements to permit them -- 
tested with SQL Server.  Thanks to Martin Busik!
See odbc_cursortype information in the ODBC POD.


=head2 Changes in DBD::ODBC 1.07 February 19, 2004

Added to Subversion version control hosted by perl.org.  Thanks Robert!  See ODBC.pm POD for more information.
Added contributing section to ODBC.pm POD -- see more details there!
Added parameter to odbc_errhandler for the NativeError -- thanks to Martin Busik.
Fix for Makefile.PL not having tab in front of $(NOOP) (Finally).
Fix for SQLForeignKeys thanks to Kevin Shepherd.

=head2 Changes in DBD::ODBC 1.06 June 19, 2003

Fixed test in t/02simple.t to skip if the DSN defined by the user has DSN= in it.
Added tests for wrong DSN, ensuring the DBI::errstr is appropriately set.
Fixed small issue in Makefile.PL for Unix systems thanks to H.Merijn Brand.
Update to NOT copy user id and password to connect string if UID or PWD parameter in connect string.
Updated Makefile.PL for dmake, per patch by Steffen Goldner.  Thanks Steffen!

=head2 Changes in DBD::ODBC 1.05 March 14, 2003

Cleaned up Makefile.PL and added Informix support thanks to Jonathan Leffler (see README.informix)
Added nicer error message when attempting to do anything while the database is disconnected. 
Fixed fetchrow_hashref('NAME_uc | NAME_lc') with odbc_more_results.
Added exporter to allow perl -MDBD::ODBC=9999 command line to determine version
Fixed for building with DBI 1.33 and greater
Removed all C++ style comments
Ensured files are in Unix format, with the exception of the README type information and Makefile.PL

=head2 Changes in DBD::ODBC 1.04 January 24, 2003

It seems that case insensitive string comparison with a limit causes problems for
multiple platforms.  strncmpi, strncasecmp, _strcmpin are all functions hit and
it seems to be a hit-or-miss.  Hence, I rewrote it to upper case the string
then do strncmp, which should be safe...sheesh.  A simple thing turned into
a headache...

=head2 Changes in DBD::ODBC 1.03 January 17, 2003

Add automatic detection of DRIVER= or DSN= to add user id and password to
connect string.


=head2 Changes in DBD::ODBC 1.02 January 6, 2003

Fix to call finish() automatically if execute is re-called in a loop 
(and test in t/02simple.t to ensure it's fixed)
 
Augmented error message when longs are truncated to help users determine where
to look for help.

Fixes for build under Win32 with Perl5.8.  


=head2 Changes in DBD::ODBC 1.01 December 9, 2002

Forgot to fix require DBI 1.201 in ODBC.pm to work for perl 5.8.  Fixed

=head2 Changes in DBD::ODBC 1.00 December 8, 2002

(Please see all changes since version 0.43)

Updated Makefile.PL to handle SQL_Wxxx types correctly with unixODBC and linking 
directly with EasySoft OOB.  Note that I could not find where iODBC defines SQL_WLONG_VARCHAR,
so I'm not sure it's fixed on all other platforms.  Should not have been a problem under
Win32...

Found that the fix in _18 was only enabled if debug enabled and it broke something else.
removed the fix.

Updated Makefile.PL to use DBI version 1.21 instead of 1.201 to facilitate builds under
latest development versions of Perl.

Updated code to use the *greater* of the column display size and the column length for
allocating column buffers.  This *should* workaround a problem with DBD::ODBC and the 
Universe database.

Added code thanks to Michael Riber to handle SQLExecDirect instead of SQLPrepare.  There are 
two ways to get this:

	$dbh->prepare($sql, { odbc_execdirect => 1}); 
 and
	$dbh->{odbc_execdirect} = 1;

When $dbh->prepare() is called with the attribute "ExecDirect" set to a non-zero value 
dbd_st_prepare do NOT call SQLPrepare, but set the sth flag odbc_exec_direct to 1.
 
Fixed numeric value binding when binding non-integral values.  Now lets the driver 
or the database handle the conversion.

Fixed makefile.pl generation of makefile to force the ODBC directory first in the 
include list to help those installing ODBC driver managers on systems which 
already have ODBC drivers in their standard include path.

=head2 Changes in DBD::ODBC 0.45_18 September 26, 2002

Updated MANIFEST to include more of the mytest/* files (examples, tests)
Fixed problem when attempting to get NUM_OF_FIELDS after execute returns no rows/columns.

=head2 Changes in DBD::ODBC 0.45_17 August 26, 2002

More fixes for multiple result sets.  Needed to clear the DBIc_FIELDS_AV
when re-executing the multiple-result set stored procedure/query.

=head2 Changes in DBD::ODBC 0.45_16 August 26, 2002

Updated to fix output parameters with multiple result sets.  The output
parameters are not set until the last result set has been retrieved.

=head2 Changes in DBD::ODBC 0.45_15 August 20, 2002

Updated for new DBIc_STATE macros (all debug, as it turned out) to be thread safer in the long run

Updated for the new DBIc_LOGFP macros

Added CLONE method

Fix for SQL Server where multiple result sets being returned from a stored proc,
where one of the result sets was empty (insert/update).
 
Added new attribute odbc_force_rebind, which forces DBD::ODBC to
check recheck for new result sets every execute.  This is only
really necessary if you have a stored procedure which returns different
result sets with each execute, given the same "prepare".  Many times
this will be automatically set by DBD::ODBC, however, if there is only
one result set in the stored proc, but it can differ with each call,
then DBD::ODBC will not know to set it. 

Updated the DBD::ODBC POD documentation to document DBD::ODBC 
private attributes and usage.
 
=head2 Changes in DBD::ODBC 0.45_14 August 13, 2002

Added support to handle (better) DBI begin_work().

Fix for binding undef parameters on SQL Server.

Fix bug when connecting twice in the same script.  Trying to set the environment ODBC version
twice against the same henv caused an error.

=head2 Changes in DBD::ODBC 0.45_13 August 9, 2002

Workaround problem with iODBC where SQLAllocHandleStd is not present in iODBC.
Made Changes file accessible via perldoc DBD::ODBC::Changes.  In the near future
the change log will be removed from here and put in changes to tidy up a bit.

=head2 Changes in DBD::ODBC 0.45_12 August 9, 2002

Fixed global destruction access violation (which was seemingly random).

=head2 Changes in DBD::ODBC 0.45_11 August 8, 2002

Updated manifest to include more samples.
Working on checking for leaks on Linux, where I might get more information about
the process memory.

Working on fixing problems with MS SQL Server binding parameters.  It seems that SQLServer
gets "confused" if you bind a NULL first.  In "older" (SQLServer 2000 initial release) versions
of the driver, it would truncate char fields.  In "newer" versions of the SQL Server
driver, it seems to only truncate dates (actually, round them to the nearest minute).  If you have
problems in the SQL Server tests, please upgrade your driver to the latest version on
Microsoft's website (MDAC 2.7 or above) http://www.microsoft.com/data

=head2 Changes in DBD::ODBC 0.45_10 July 30, 2002

Added database specific tests to ensure things are working.  Some of the tests may
not work for all people or may not be desirable.  I have tried to keep them as
safe as possible, but if they don't work, please let me know.

Added support for the internal function GetFunctions to handle ODBC 3's
SQL_API_ODBC3_ALL_FUNCTIONS.  Would have caused a memory overwrite on the
stack if it was called. 
 

=head2 Changes in DBD::ODBC 0.45_9 July 30, 2002

Fixed bug in procedure handling for SQLServer.  Was not re-describing the result sets
if the SQLMoreResults in the execute needs to be called.
  
=head2 Changes in DBD::ODBC 0.45_8 July 25, 2002

Fixed bug in tracing code when binding an undef parameter which did not
happen to have a valid buffer with tracing level >= 2
 
Fixed bug when binding undef after a valid data bind on a timestamp.  The
Scale value was being calculated based upon the string that had been bound
prior to the bind of the undef and if that had a sub-second value, then
the scale would be set to the wrong value...I.e. 

 bind_param(1, '2000-05-17 00:01:00.250', SQL_TYPE_TIMESTAMP) then
 execute
 bind_param(1, undef, SQL_TYPE_TIMESTAMP) then

Fixed SQL Server issue when binding a null and the length was set to 0 instead of 1

=head2 Changes in DBD::ODBC 0.45_7 July 25, 2002

Adding support for array binding, but not finished.

Fixed bug where SqlServer Stored procedures which perform INSERT would not correctly
return a result set.  Thanks to Joe Tebelskis for finding it and Martin Evans for
supplying a fix.

Fixed bug where binding the empty string would cuase a problem.  Fixed and added
test in t/07bind.t.
 
=head2 Changes in DBD::ODBC 0.45_6 July 24, 2002

Added support for new DBI ParamValues feature.
 
=head2 Changes in DBD::ODBC 0.45_5 July 23, 2002

Added odbc_err_handler and odbc_async_exec thanks to patches by David L. Good.
See example in mytest/testerrhandler.pl

Here's the notes about it:

 I've implemented two separate functions.  The first is an "error
 handler" similar to that in DBD::Sybase.  The error handler can be used
 to intercept error and status messages from the server.  It is the only
 way (at least currently) that you can retrieve non-error status messages
 when execution is successful.

 To use the error handler, set the "odbc_err_handler" attribute on
 your database handle to a reference to a subroutine that will act
 as the error handler.  This subroutine will be passed two args, the
 SQLSTATE and the error message.  If the subroutine returns 0, the
 error message will be otherwise ignored.  If it returns non-zero,
 the error message will be processed normally.

 The second function implemented is asynchronous execution.  It's only
 useful for retrieving server messages with an error handler during an
 execute() that takes a long time (such as a DBCC on a large database) ODBC
 doesn't have the concept of a callback routine like Sybase's DBlib/CTlib
 does, so asynchronous execution is needed to be able to get the server
 messages before the SQL statement is done processing.

 To use asynchronous execution, set the "odbc_async_exec" attribute on
 your database handle to 1.  Not all ODBC drivers support asynchronous
 execution.  To see if yours does, set odbc_async_exec to 1 and then check
 it's value.  If the value is 1, your ODBC driver can do asynchronous
 execution.  If the value is 0, your ODBC driver cannot.

=head2 Changes in DBD::ODBC 0.45_4 July 22, 2002

More fixes for DB2 tests and timestamp handling.
 
=head2 Changes in DBD::ODBC 0.45_3 July 22, 2002

Changes to internal timestamp type handling and test structure to ensure tests
work for all platforms.  DB2 was giving me fits due to bad assumptions.  Thanks
to Martin Evans (again) for help in identifying the problems and helping research
solutions.  This includes the scale/precision values to correctly store full timestamps.

=head2 Changes in DBD::ODBC 0.45_2 July 19, 2002

Moving API usage to ODBC 3.0 specifications.  With lots of help from Martin Evans (again!).
Thanks Martin!!!!!
 
=head2 Changes in DBD::ODBC 0.44 July 18, 2002

.44 was never officially released.
Fix for do() and execute to handle DB2 correctly.  Patch/discovery thanks to Martin Evans.
Partly moving towards defaulting to ODBC 3.x standards.

=head2 Changes in DBD::ODBC 0.43 July 18, 2002

Fix for FoxPro (and potentially other) Drivers!!!!!

Add support for DBI column_info

Fix for binding undef value which comes from dereferencing hash

Fix to make all bound columns word (int) aligned in the buffer.

=head2 Changes in DBD::ODBC 0.42 July 8, 2002

Added patches to the tests to support ActiveState's automated build process.

Fix ping() to try SQLTables for a test, instead of a strange query.  

=head2 Changes in DBD::ODBC 0.41 April 15, 2002

Fixed problem where SQLDescribeParam would fail (probably
bug in ODBC driver).  Now reverts to SQL_VARCHAR if that
happens, instead of failing the query.

Fixed error report when using Oracle's driver.  There is
a known problem.  Left the error on the test, but added
warning indicating it's a known problem.

=head2 Changes in DBD::ODBC 0.40 April 12, 2002

Most significant change is the change in the default binding
type which forces DBD::ODBC to attempt to determine the bind
type if one is not passed.  I decided to make this the default
behavior to make things as simple as possible.

Fixed connection code put in 0.39 to work correctly.

Two minor patches for building, one for Cygwin one
if both iODBC and unixODBC libraries are installed.
Probably need better command line on this, but if 
someone has the problem, please let me know (and 
hopefully send a patch with it).

=head2 Changes in DBD::ODBC 0.39 March 12, 2002
 
See mytest/longbin.pl for demonstration of inserting and retrieving
long binary files to/from the db.  Uses MD5 algorithm to verify data.
Please do some similar test(s) with your database before using it
in production.  The various bind types are different for each database!

Finally removed distribution of old iODBC.  See www.iodbc.org or
www.unixodbc.org for newer/better versions of the ODBC driver
manager for Unix (and others?). 

Added ability to force ODBC environment version.
 
Fix to SQLColAttributes.

Changes to connect sequence to provide better error
messages for those using DSN-less connections.

=head2 Changes in DBD::ODBC 0.38 February 12, 2002

Fixed do function (again) thanks to work by Martin Evans.

=head2 Changes in DBD::ODBC 0.37 February 10, 2002

Patches for get_info where return type is string.  Patches
thanks to Steffen Goldner.  Thanks Steffen!

Patched get_info to NOT attempt to get data for SQL_DRIVER_HSTMT
and SQL_DRIVER_HDESC as they expect data in and have limited value
(IMHO).

Further fixed build for ODBC 2.x drivers.  The new SQLExecDirect
code had SQLAllocHandle which is a 3.x function, not a 2.x function.
Sigh.  I should have caught that the first time.  Signed, the Mad-and-
not-thorough-enough-patcher.

Additionally, a random core dump occurred in the tests, based upon the
new SQLExecDirect code.  This has been fixed.
 
 
=head2 Changes in DBD::ODBC 0.36 February 10, 2002

Fixed build for ODBC 2.x drivers.  The new SQLExecDirect code
had SQLFreeHandle which is a 3.x function, not a 2.x function.
 
=head2 Changes in DBD::ODBC 0.35 February 9, 2002

Fixed (finally) multiple result sets with differing
numbers of columns.  The final fix was to call
SQLFreeStmt(SQL_UNBIND) before repreparing
the statement for the next query.

Added more to the multi-statement tests to ensure
the data retrieved was what was expected.

Now, DBD::ODBC overrides DBI's do to call SQLExecDirect
for simple statements (those without parameters).
Please advise if you run into problems.  Hopefully,
this will provide some small speed improvement for
simple "do" statements.  You can also call
$dbh->func($stmt, ExecDirect).  I'm not sure this has
great value unless you need to ensure SQLExecDirect
is being called.  Patches thanks to Merijn Broeren.
Thanks Merijn!
   
=head2 Changes in DBD::ODBC 0.34 February 7, 2002
 
Further revamped tests to attempt to determine if SQLDescribeParam
will work to handle the binding types.  The t/08bind.t attempts
to determine if SQLDescribeParam is supported.  note that Oracle's
ODBC driver under NT doesn't work correctly when binding dates
using the ODBC date formatting {d } or {ts }.  So, test #3 will
fail in t/08bind.t

New support for primary_key_info thanks to patches by Martin Evans.
New support for catalog, schema, table and table_type in table_info
thanks to Martin Evans.  Thanks Martin for your work and your
continuing testing, suggestions and general support!

Support for upcoming dbi get_info.
 
=head2 Changes in DBD::ODBC 0.33_3 February 4, 2002

Revamped tests to include tests for multiple result sets.
The tests are ODBC driver platform specific and will be skipped
for drivers which do not support multiple result sets.
 
=head2 Changes in DBD::ODBC 0.33_2 February 4, 2002

Finally tested new binding techniques with SQL Server 2000,
but there is a nice little bug in their MDAC and ODBC
drivers according to the knowledge base article # Q273813, titled

   "FIX: "Incorrect Syntax near the Keyword 'by' "
   Error Message with Column Names of "C", "CA" or "CAS" (Q273813)

DBD::ODBC now does not name any of the columns A, B, C, or D
they are now COL_A, COL_B, COL_C, COL_D.

 *** NOTE: *** I AM STRONGLY CONSIDERING MAKING THE NEW
 BINDING the default for future versions.  I do not believe
 it will break much existing code (if any) as anyone binding
 to non VARCHAR (without the ODBC driver doing a good conversion
 from the VARCHAR) will have a problem.  It may be subtle, however,
 since much code will work, but say, binding dates may not with
 some drivers.
   
 Please comment soon...
   
=head2 Changes in DBD::ODBC 0.33_1 February 4, 2002

*** WARNING: ***
 
 Changes to the binding code to allow the use of SQLDescribeParam
 to determine if the type of column being bound.  This is
 experimental and activated by setting
 
  $dbh->{odbc_default_bind_type} = 0; # before creating the query...

Currently the default value of odbc_default_bind_type = SQL_VARCHAR
which mimicks the current behavior.  If you set
odbc_default_bind_type to 0, then SQLDescribeParam will be
called to determine the columen type.  Not ALL databases
handle this correctly.  For example, Oracle returns
SQL_VARCHAR for all types and attempts to convert to the
correct type for us.  However, if you use the ODBC escaped
date/time format such as: {ts '1998-05-13 00:01:00'} then
Oracle complains.  If you bind this with a SQL_TIMESTAMP type,
however, Oracle's ODBC driver will parse the time/date correctly.
Use at your own risk!

Fix to dbdimp.c to allow quoted identifiers to begin/end
with either " or '.
The following will not be treated as if they have a bind placeholder:

   "isEstimated?"
   '01-JAN-1987 00:00:00'
   'Does anyone insert a ?'

				    
=head2 Changes in DBD::ODBC 0.32 January 22, 2002

More SAP patches to Makfile.PL to eliminate the call to Data Sources

A patch to the test (for SAP and potentially others), to allow
fallback to SQL_TYPE_DATE in the tests
 
=head2 Changes in DBD::ODBC 0.31 January 18, 2002

Added SAP patches to build directly against SAP driver instead of
driver manager thanks to Flemming Frandsen (thanks!)

Added support to fix ping for Oracle8.  May break other databases,
so please report this as soon as possible.  The downside is that
we need to actually execute the dummy query.
 

=head2 Changes in DBD::ODBC 0.30 January 8, 2002

Added ping patch for Solid courtesy of Marko Asplund

Updated disconnect to rollback if autocommit is not on.
This should silence some errors when disconnecting.

Updated SQL_ROWSET_SIZE attribute.  Needed to force it to
odbc_SQL_ROWSET_SIZE to obey the DBI rules.

Added odbc_SQL_DRIVER_ODBC_VER, which obtains the version of
the Driver upon connect.  This internal capture of the version is
a read-only attributed and is used during array binding of parameters.
 
Added odbc_ignore_named_placeholders attribute to facilicate
creating triggers within SAPDB and Oracle, to name two. The
syntax in these DBs is to allow use of :old and :new to
access column values before and after updates.  Example:

 $dbh->{odbc_ignore_named_placeholders} = 1; # set it for all future statements
					  # ignores :foo, :new, etc, but not :1 or ?
 $dbh->do("create or replace etc :new.D = sysdate etc");
 

=head2 Changes in DBD::ODBC 0.29 August 22, 2001

Cygwin patches from Neil Lunn (untested by me).  Thanks Neil!
 
SQL_ROWSET_SIZE attribute patch from Andrew Brown 

 There are only 2 additional lines allowing for the setting of
 SQL_ROWSET_SIZE as db handle option.

 The purpose to my madness is simple. SqlServer (7 anyway) by default
 supports only one select statement at once (using std ODBC cursors).
 According to the SqlServer documentation you can alter the default setting
 of
 three values to force the use of server cursors - in which case multiple
 selects are possible.

 The code change allows for:
 $dbh->{SQL_ROWSET_SIZE} = 2;    # Any value > 1

 For this very purpose.

 The setting of SQL_ROWSET_SIZE only affects the extended fetch command as
 far as I can work out and thus setting this option shouldn't affect
 DBD::ODBC operations directly in any way.

 Andrew


VMS and other patches from Martin Evans (thanks!)

[1] a fix for Makefile.PL to build DBD::ODBC on OpenVMS.

[2] fix trace message coredumping after SQLDriverConnect

[3] fix call to SQLCancel which fails to pass the statement handle properly.

[4] consume diagnostics after SQLDriverConnect/SQLConnect call or they remain
    until the next error occurs and it then looks confusing (this is due to
    ODBC spec for SQLError). e.g. test 02simple returns a data truncated error
    only now instead of all the informational diags that are left from the
    connect call, like the "database changed", "language changed" messages you
    get from MS SQL Server.

Replaced C++ style comments with C style to support more platforms more easily.

Fixed bug which use the single quote (') instead of a double quote (") for "literal" column names.  This
   helped when having a colon (:) in the column name.

Fixed bug which would cause DBD::ODBC to core-dump (crash) if DBI tracing level was greater than 3.

Fixed problem where ODBC.pm would have "use of uninitialized variable" if calling DBI's type_info.

Fixed problem where ODBC.xs *may* have an overrun when calling SQLDataSources. 

Fixed problem with DBI 1.14, where fprintf was being called instead of PerlIO_printf for debug information

Fixed problem building with unixODBC per patch from Nick Gorham   

Added ability to bind_param_inout() via patches from Jeremy Cooper.  Haven't figured out a good, non-db specific
   way to test.  My current test platform attempts to determine the connected database type via
   ugly hacks and will test, if it thinks it can.  Feel free to patch and send me something...Also, my
   current Oracle ODBC driver fails miserably and dies.

Updated t/02simple.t to not print an error, when there is not one.
   
=head2 Changes in DBD::ODBC 0.28 March 23, 2000

Added support for SQLSpecialColumns thanks to patch provided by Martin J. Evans [martin@easysoft.com]

Fixed bug introduced in 0.26 which was introduced of SQLMoreResults was not supported by the driver.

=head2 Changes in DBD::ODBC 0.27 March 8, 2000

Examined patch for ping method to repair problem reported by Chris Bezil.  Thanks Chris!

Added simple test for ping method working which should identify this in the future.

=head2 Changes in DBD::ODBC 0.26 March 5, 2000

Put in patch for returning only positive rowcounts from dbd_st_execute.  The original patch
was submitted by Jon Smirl and put back in by David Good.  Reasoning seems sound, so I put it
back in.  However, any databases that return negative rowcounts for specific reasons,
will no longer do so.

Put in David Good's patch for multiple result sets.  Thanks David!  See mytest\moreresults.pl for
an example of usage.

Added readme.txt in iodbcsrc explaining an issue there with iODBC 2.50.3 and C<data_sources>.

Put in rudimentary cancel support via SQLCancel.  Call $sth->cencel to utilize.  However, it is largely
untested by me, as I do not have a good sample for this yet.  It may come in handy with threaded
perl, someday or it may work in a signal handler.
   
=head2 Changes in DBD::ODBC 0.25 March 4, 2000

Added conditional compilation for SQL_WVARCHAR and SQL_WLONGVARCHAR.  If they
are not defined by your driver manager, they will not be compiled in to the code.
If you would like to support these types on some platforms, you may be able to
#define SQL_WVARCHAR (-9)
#define SQL_WLONGVARCHAR (-10)

Added more long tests with binding in t\09bind.t.  Note use of bind_param!
 
=head2 Changes in DBD::ODBC 0.24 February 24, 2000

Fixed Test #13 in 02simple.t.  Would fail, improperly, if there was only one data source defined.

Fixed (hopefully) SQL Server 7 and ntext type "Out of Memory!" errors via patch from Thomas Lowery.  Thanks Thomas!

Added more support for Solid to handle the fact that it does not support data_sources nor SQLDriverConnect.
Patch supplied by Samuli Karkkainen [skarkkai@woods.iki.fi].  Thanks!  It's untested by me, however.

Added some information from Adam Curtin about a bug in iodbc 2.50.3's data_sources.  See
iodbcsrc\readme.txt.

Added information in this pod from Stephen Arehart regarding DSNLess connections.

Added fix for sp_prepare/sp_execute bug reported by Paul G. Weiss.

Added some code for handling a hint on disconnect where the user gets an error for not committing.
 
=head2 Changes in DBD::ODBC 0.22 September 8, 1999

Fixed for threaded perl builds.  Note that this was tested only on Win32, with no threads in use and using DBI 1.13.
Note, for ActiveState/PERL_OBJECT builds, DBI 1.13_01 is required as of 9/8/99.  
If you are using ActiveState's perl, this can be installed by using PPM.


=head2 Changes in DBD::ODBC 0.21 

Thanks to all who provided patches!

Added ability to connect to an ODBC source without prior creation of DSN.  See mytest/contest.pl for example with MS Access.
(Also note that you will need documentation for your ODBC driver -- which, sadly, can be difficult to find).

Fixed case sensitivity in tests.

Hopefully fixed test #4 in t/09bind.t.  Updated it to insert the date column and updated it to find the right
type of the column.  However, it doesn't seem to work on my Linux test machine, using the OpenLink drivers 
with MS-SQL Server (6.5).  It complains about binding the date time.  The same test works under Win32 with 
SQL Server 6.5, Oracle 8.0.3 and MS Access 97 ODBC drivers.  Hmmph.

Fixed some binary type issues (patches from Jon Smirl)

Added SQLStatistics, SQLForeignKeys, SQLPrimaryKeys (patches from Jon Smirl)
Thanks (again), Jon, for providing the build_results function to help reduce duplicate code!

Worked on LongTruncOk for Openlink drivers.

Note: those trying to bind variables need to remember that you should use the following syntax:

	use DBI;
	...
	$sth->bind_param(1, $str, DBI::SQL_LONGVARCHAR);

Added support for unixodbc (per Nick Gorham)
Added support for OpenLinks udbc (per Patrick van Kleef)
Added Support for esodbc (per Martin Evans)
Added Support for Easysoft (per Bob Kline)

Changed table_info to produce a list of views, too.
Fixed bug in SQLColumns call.
Fixed blob handling via patches from Jochen Wiedmann.
Added data_sources capability via snarfing code from DBD::Adabas (Jochen Wiedmann)

=head2 Changes in DBD::ODBC 0.20 August 14, 1998

SQLColAttributes fixes for SQL Server and MySQL. Fixed tables method
by renaming to new table_info method. Added new tyoe_info_all method.
Improved Makefile.PL support for Adabase.

=head2 Changes in DBD::ODBC 0.19

Added iODBC source code to distribution.Fall-back to using iODBC header
files in some cases.

=head2 Changes in DBD::ODBC 0.18

Enhancements to build process. Better handling of errors in
error handling code.

=head2 Changes in DBD::ODBC 0.17 

This release is mostly due to the good work of Jeff Urlwin.
My eternal thanks to you Jeff.

Fixed "SQLNumResultCols err" on joins and 'order by' with some
drivers (see Microsoft Knowledge Base article #Q124899).
Thanks to Paul O'Fallon for that one.

Added more (probably incomplete) support for unix ODBC in Makefile.PL

Increased default SQL_COLUMN_DISPLAY_SIZE and SQL_COLUMN_LENGTH to 2000
for drivers that don't provide a way to query them dynamically. Was 100!

When fetch reaches the end-of-data it automatically frees the internal
ODBC statement handle and marks the DBI statement handle as inactive
(thus an explicit 'finish' is *not* required).

Also:

LongTruncOk for Oracle ODBC (where fbh->datalen < 0)

Added tracing into SQLBindParameter (help diagnose oracle odbc bug)

Fixed/worked around bug/result from Latest Oracle ODBC driver where in
SQLColAttribute cbInfoValue was changed to 0 to indicate fDesc had a value

Added work around for compiling w/ActiveState PRK (PERL_OBJECT)

Updated tests to include date insert and type

Added more "backup" SQL_xxx types for tests                                  

Updated bind test to test binding select

 NOTE: bind insert fails on Paradox driver (don't know why)

Added support for: (see notes below)

  SQLGetInfo       via $dbh->func(xxx, GetInfo)
  SQLGetTypeInfo   via $dbh->func(xxx, GetTypeInfo)
  SQLDescribeCol   via $sth->func(colno, DescribeCol)
  SQLColAttributes via $sth->func(xxx, colno, ColAttributes)
  SQLGetFunctions  via $dbh->func(xxx, GetFunctions)
  SQLColumns       via $dbh->func(catalog, schema, table, column, 'columns')

Fixed $DBI::err to reflect the real ODBC error code
which is a 5 char code, not necessarily numeric.

Fixed fetches when LongTruncOk == 1.

Updated tests to pass more often (hopefully 100% <G>)

Updated tests to test long reading, inserting and the LongTruncOk attribute.

Updated tests to be less driver specific.  

They now rely upon SQLGetTypeInfo I<heavily> in order to create the tables.
The test use this function to "ask" the driver for the name of the SQL type
to correctly create long, varchar, etc types.  For example, in Oracle the
SQL_VARCHAR type is VARCHAR2, while MS Access uses TEXT for the SQL Name.  
Again, in Oracle the SQL_LONGVARCHAR is LONG, while in Access it's MEMO.
The tests currently handle this correctly (at least with Access and Oracle,
MS SQL server will be tested also).

=cut
