@echo off
REM Setup/installer for Windows NT/2000 port of Logcheck
REM v1.0 26-Aug-2001 JP Vossen <jp@jpsdomain.org>
REM v1.1 31-Aug-2001 JPV Added auditpol.exe and section to set NT logging
REM v1.2 01-Sep-2001 JPV Added Event Log settings, NTFS ACLs and interactive
REM 	help
REM v1.3 05-Sep-2001 JPV BUGFIX: Break Auditpol into 2 parts
REM v1.3a 05-Nov-2001 JPV BUGFIX: Added a missing "echo" re: settiong NTFS
REM	perms.

REM Get just the "Setup" part, no path, no ".bat".  Intuitive, huh?
Set MyName=%~n0

REM Get the date (also quite intuitive)
for /f "tokens=*" %%I in ('./date.exe') do set DATE=%%I

cls
echo.
echo.
echo Welcome to the Windows port of Logcheck, the famous UNIX log processing
echo tool by Craig Rowland. Ported by JP Vossen.

:TheTop
echo.
echo.
echo %MyName% will ask you a few questions, then install WinLogcheck.

echo.
echo.
echo First, where do you want to install Logcheck?  The default is:
echo 	%%SYSTEMROOT%%\etc (%SYSTEMROOT%\etc)
call :GetInput
if     "%INPUT%"=="" set LCROOTW=%SYSTEMROOT%\etc
if not "%INPUT%"=="" set LCROOTW=%INPUT%

REM Set the Logcheck root UNIX. This uses a little known string substituion
REM function of CMD.exe to replace "\" with "/".  Similar to MyName above.
set LCROOTU=%LCROOTW:\=/%


:GetSMTPSERVER
echo.
echo.
echo Next, I need to know where your mail server is.  Enter the Fully Qualified
echo Domain Name or the IP Address of the SMTP server you want Logcheck to use to
echo send e-mail alerts.
call :GetInput
if     "%INPUT%"=="" goto :GetSMTPServer
if not "%INPUT%"=="" set SMTPSERVER=%INPUT%


echo.
echo.
echo Now, I need to know what e-mail address to send alerts to.
echo The default is administrator@%SMTPSERVER%
call :GetInput
if     "%INPUT%"=="" set SYSADMIN=administrator@%SMTPSERVER%
if not "%INPUT%"=="" set SYSADMIN=%INPUT%


echo.
echo.
echo Would you like me to set permissions so that only System and the local
echo Administrators group have full control of %LCROOTW%?
call :YesOrNo
call :GetInput
set SETACLS=y
if /I "%INPUT%"=="no" set SETACLS=n


echo.
echo.
echo Would you like me to set the Application, Security and System logs to 12 Meg
echo and to "overwrite when needed?" Usually the latter is not a recommended
echo setting, but since you are going to actually be MONITORING the logs and can
echo take action if necessary, it's OK. Also, I'm not going to set the DNS,
echo Replication or Directory logs, so if those exist you'll have to set them
echo anyway. You will be given a chance to use Event Viewer to verify or change
echo these settings at the end of setup.
echo.
echo Shall I set the Event Logs to 12 Meg, "overwrite when needed"?
call :YesOrNo
call :GetInput
set SETEVENTLOGS=y
if /I "%INPUT%"=="no" set SETEVENTLOGS=n


echo.
echo.
echo Finally, would you like me to turn on auditing (logging) for you? You MUST
echo have this on so Logcheck has logs to check, but you may go do it yourself if
echo you want. I will use the following policy (not all types applicable to all
echo systems):
echo.
call :ShowLogPolicy
echo.
echo Shall I set this logging policy?
call :YesOrNo
call :GetInput
set SETLOGGING=y
if /I "%INPUT%"=="no" set SETLOGGING=n


echo.
echo.
echo.
echo.
echo OK, that's it.  Here are the settings you've chosen:
echo.
echo Install Directory:	%LCROOTW%
echo.
echo SMTP Server:		%SMTPSERVER%
echo.
echo E-Mail Address:		%SYSADMIN%


if not "%SETACLS%"=="n" (
    echo.
    echo Give only System and Administrators full control of %LCROOTW%
)


if not "%SETEVENTLOGS%"=="n" (
    echo.
    echo Set the Application, Security and System logs to 12 Meg and to
    echo "overwrite" when needed
)

if not "%SETLOGGING%"=="n" (
    echo.
    pause
    echo.
    call :ShowLogPolicy
)

echo.
echo.
echo Do you want to change these options? Answer "yes" to start over; any other
echo answer means no. (Hint, use the UP arrow key to cycle back through your
echo answers.)
call :GetInput
if /I "%INPUT%"=="yes" goto :TheTop

echo.
echo.
echo Configuring scripts...
REM Sed needs double '\', so we double them in LCROOTW, if any are there.
set LCROOTWSED=%LCROOTW:\=\\%
REM Also, we need to pass '%SYSTEM%' to sed, not have it interpolated.
REM So we have to use two percent signs, with the double '\' for sed.
sed -e "s;set LCROOTW=%%SYSTEMROOT%%\\etc;set LCROOTW=%LCROOTWSED%;"      < wrapper.cmd  > wrapper.1
sed -e "s;set SYSADMIN=your_address@company.com;set SYSADMIN=%SYSADMIN%;" < wrapper.1    > wrapper.2
sed -e "s;set SMTPSERVER=mail.company.com;set SMTPSERVER=%SMTPSERVER%;"   < wrapper.2    > wrapper.3
sed -e "s;REM Installed By: Your_Name_Here;REM Installed By: %MyName% on %DATE%;" < wrapper.3    > wrapper.cmd
sed -e "s;set SYSADMIN=your_address@company.com;set SYSADMIN=%SYSADMIN%;" < TestBlat.cmd > TestBlat.1
sed -e "s;set SMTPSERVER=mail.company.com;set SMTPSERVER=%SMTPSERVER%;"   < TestBlat.1   > TestBlat.cmd


echo.
echo Starting schedule service...
rem NT w/o IE5.x
  net start "scheduler" > NUL 2>&1
rem NT w/ IE5.x or W2K
  net start "Task Scheduler" > NUL 2>&1


echo.
echo Creating directories...
if not exist %LCROOTW%       md %LCROOTW%
if not exist %LCROOTW%\lcwin md %LCROOTW%\lcwin
if not exist %LCROOTW%\bin   md %LCROOTW%\bin
if not exist %LCROOTW%\tmp   md %LCROOTW%\tmp
if not exist %LCROOTW%\docs  md %LCROOTW%\docs


echo.
echo Copying files...
copy *.exe %LCROOTW%\bin        > NUL
copy *.cmd %LCROOTW%\bin        > NUL
copy *.sh  %LCROOTW%\bin        > NUL
copy *.txt %LCROOTW%\docs       > NUL
copy *.hlp %LCROOTW%\docs       > NUL
copy logcheck.* %LCROOTW%\lcwin > NUL
del %LCROOTW%\lcwin\*.sh        > NUL
del %LCROOTW%\bin\sed.exe       > NUL
del %LCROOTW%\bin\auditpol.exe  > NUL


echo.
echo Installing Blat (see %LCROOTW%\docs\Blat-Readme.txt)...
Blat -install %SMTPSERVER% %SYSADMIN% > NUL

if not "%SETACLS%"=="n" (
    echo.
    echo Giving System and Administrators full control of %LCROOTW%...
    echo y|cacls %LCROOTW% /T /C /G Administrators:F > NUL
    cacls %LCROOTW% /T /E /C /P System:F > NUL
    rem Using cacls may remove "inherit permissions" when using SCM/2000!
)


if not %SETEVENTLOGS%=="n" (
    echo.
    echo Setting the Application, Security and System logs to 12 Meg and to
    echo "overwrite" when needed...
    echo.
    call :SetEventLogs
)


if not "%SETLOGGING%"=="n" (
    echo.
    echo Setting Audit properties...
    echo You should check the results using User Manager, Policies, Audit ^(NT^) or
    echo Local Security Settings ^(W2K^)!
    echo.
    REM These should *always* work
    auditpol /enable /System:all /Logon:all /Object:failure /Privilege:failure /Process:none /Policy:all /Sam:all > Nul 2>&1
    REM These will fail under NT4, giving the useful error message "... This function is only valid in Windows NT Mode."
    auditpol /Directory:failure /Account:all > Nul 2>&1
)


echo.
echo.
echo.
echo.
echo.
echo Finished.  Now, YOU still need to do a few things.
echo.
echo.

if not "%SETACLS%"=="n" (
echo 1.  You should verify that the permissions on %LCROOTW% were set correctly.
echo You might also need to make changes to them.
) else (
echo 1. Since you did not let me set permissions, you should do that now.
)
echo I'll open Explorer so you can do that.  Close the Explorer window when
echo finished and we'll continue.
echo.
pause
explorer /n,/select,%LCROOTW%
echo.
echo Press any key when finished with Explorer.
pause > NUL

echo.
echo.
echo 2. Start logging stuff! Even if you let me set the logging policy, use User
echo Manager, Policies, Audit or Local Security Settings to verify your logging
echo settings. Then use Event Viewer to set your logs to a decent size (at LEAST
echo 6-12 Meg). Now use Windows Explorer to set logging on important files.
echo.
echo I'll open Event Viewer so you can do that now. Close it when finished and
echo we'll continue, but remember which logs exist -- we need that next.
echo.
pause
eventvwr
echo.
echo Press any key when finished with Event Viewer.
pause > NUL

echo.
echo.
echo 3. You need to edit %LCROOTW%\bin\wrapper.cmd and REM out
echo the logs you don't have on this machine, due to a poorly written MS API. See
echo the FAQ or Install document for more information. I'll open Notepad so you
echo can do that now. You'll want to page down a bit -- it's pretty obvious where
echo to comment.
echo.
pause
notepad %LCROOTW%\bin\wrapper.cmd
echo.
echo Press any key when finished editing wrapper.cmd with Notepad.
pause > NUL


echo.
echo.
echo 4. Make sure e-mail works -- go try %LCROOTW%\bin\TestBlat.cmd.
echo.
echo.
echo 5. Add %LCROOTW%\bin\wrapper.cmd to your scheduler and make sure the
echo scheduler is set to start automatically. I've started it for now. See
echo %LCROOTW%\docs\INSTALL-Windows.txt for more details. If your scheduler runs
echo under a different account than SYSTEM or is not in the administrators group
echo (which is a good thing), you'll need to add permissions for that account to
echo %LCROOTW%.
echo.
echo.
echo 6. Finally, you can remove this directory if you want, as we're finished
echo with it.
echo.
echo.


goto :Cleanup
REM ======================================================================
REM OK, this is the bizaar way procedures are implemented.
REM You call the procedure name (you DO need the ':'), which then returns
REM via a goto :EOF
REM Look, it's DOS -- what can I say?!?

:GetInput

    set I=
    set INPUT=
    echo.
    echo You must use CTRL-Z followed by ENTER (or vice versa) to end your input:
    REM Hey, it's DOS -- what can I say? :-)
    copy con input.tmp > NUL
    for /f "tokens=*" %%I in ('type input.tmp') do set INPUT=%%I
    del input.tmp > NUL

Goto :EOF

REM ======================================================================
:YesOrNo

    echo Answer "no" not to, any other answer means yes.

Goto :EOF

REM ======================================================================
:ShowLogPolicy

    echo Enable Auditing
    echo System                    = Success and Failure
    echo Logon                     = Success and Failure
    echo Object Access             = Failure
    echo Privilege Use             = Failure
    echo Process Tracking          = No
    echo Policy Change             = Success and Failure
    echo Account Management        = Success and Failure
    echo Directory Service Access  = Failure
    echo Account Logon             = Success and Failure

Goto :EOF

REM ======================================================================
:SetEventLogs

    rem Set Event Log behavior
      rem Note that the leg settings are in hex, you will probably want to convert them
      rem to decimal.  Use the Scientific view in "calc"...
    
      rem For example: 80,000 Hex = 524,288 decimal /1024     = 512 K  (the default Size)
      rem              93a80 Hex  = 604,800 decimal /60/60/24 = 7 Days (the default Retention)
    
      rem            00bc0000 Hex = 12,320,768 decimal /1024  =  12,032 K /1024 =  11.75 Meg
    
    rem Create a temp REG file to set All 3 Event Logs to 12 Meg and
    rem allow overwrite "as needed"
    echo REGEDIT4                                                                     > .\SEL.reg
    echo.                                                                            >> .\SEL.reg
    echo [HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\EventLog\Application] >> .\SEL.reg
    echo  "MaxSize"=dword:00bc0000                                                   >> .\SEL.reg
    echo  "Retention"=dword:00000000                                                 >> .\SEL.reg
    echo.                                                                            >> .\SEL.reg
    echo  [HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\EventLog\Security]   >> .\SEL.reg
    echo  "MaxSize"=dword:00bc0000                                                   >> .\SEL.reg
    echo  "Retention"=dword:00000000                                                 >> .\SEL.reg
    echo.                                                                            >> .\SEL.reg
    echo  [HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\EventLog\System]     >> .\SEL.reg
    echo  "MaxSize"=dword:00bc0000                                                   >> .\SEL.reg
    echo  "Retention"=dword:00000000                                                 >> .\SEL.reg

    REM Apply the settings then delete the temp file
    regedit /s .\SEL.reg
    del .\SEL.reg > NUL

Goto :EOF


REM ======================================================================
:Cleanup
set INPUT=
set DATE=
set LCROOTW=
set LCROOTWSED=
set SETLOGGING=
set SETACLS=
set SETEVENTLOGS=
del wrapper.?  > NUL
del TestBlat.? > NUL

